	.Z80
;***********************************
;*	Z80 TEST PROTOTYPE
;*	LOAD MONITOR FROM ROM INTO RAM AND EXECUTE PROGRAM
;*	ANDREW LYNCH
;*	LYNCHAJ@YAHOO COM
;*	15 FEB 2007
;***********************************


;********************* CONSTANTS ****************************************

RAMTOP:		 EQU	0FFFFh	; HIGHEST ADDRESSABLE MEMORY LOCATION
MONSTART:	 EQU	0F800h	; START OF 6116 SRAM 2KB X 8 RAM F800H-FFFFH
RAMBOTTOM:	 EQU	08000h	; BEGINNING OF UPPER 32K RAM PAGE
END:		 EQU	0FFh	; MARK END OF TEXT
CR:		 EQU	0DH	; ASCII CARRIAGE RETURN CHARACTER
LF:		 EQU	0AH	; ASCII LINE FEED CHARACTER
ESC:		 EQU	1BH	; ASCII ESCAPE CHARACTER

ROMSTART_CPM:	 EQU	00200h	; WHERE THE CCP+BDOS+BIOS IS STORED IN ROM
RAMTARG_CPM:	 EQU	0D000h	; WHERE THE CCP+BDOS+BIOS STARTS IN RAM (ENTRY POINT)
MOVSIZ_CPM:	 EQU	029FFh	; CCP, BDOS, + BIOS IS 11KB IN LENGTH

CPM_ENTRY	 EQU	0E600h	; CP/M 2.2 ENTRY POINT (MAY CHANGE)



;*******************************************************************
;*	START AFTER RESET
;*	FUNCTION	: READY SYSTEM, LOAD MONITOR INTO RAM AND START
;*******************************************************************

	 ORG	00100h

	DI			; DISABLE INTERRUPT
	LD	SP,RAMTOP	; SET STACK POINTER TO TOP OFF RAM
	IM	1		; SET INTERRUPT MODE 1

	LD	HL,ROMSTART_CPM	; WHERE IN ROM CP/M IS STORED (FIRST BYTE)
        LD	DE,RAMTARG_CPM	; WHERE IN RAM TO MOVE MONITOR TO (FIRST BYTE)
	LD	BC,MOVSIZ_CPM	; NUMBER OF BYTES TO MOVE FROM ROM TO RAM
	LDIR			; PERFORM BLOCK COPY OF CP/M TO UPPER RAM PAGE

	EI			; ENABLE INTERRUPTS (ACCESS TO MONITOR WHILE CP/M RUNNING)

	JP	CPM_ENTRY	; JUMP TO START OF MONITOR


;************************************************************************
;*	MASKABLE INTERRUPT-PROGRAM
;*	FUNCTION	:
;*	INPUT		:
;*	OUTPUT		: 
;*	USES		: 
;*	CALLS		: NONE
;*	INFO		:
;*	TESTED		: 2 FEB 2007
;************************************************************************

;	 ORG	00038h		; INT MODE 1
;	DI			; DISABLE
TESTLOOP:	
;	OUT	(068h),A
;	JP	TESTLOOP

;	JP	$MONITOR_ENTRY	; GO TO MONITOR
;	EI			; ENABLE AGAIN
;	RETI			; RETURN FROM INTERRUPT


;************************************************************************
;*	NONMASKABLE INTERRUPT-PROGRAM
;*	FUNCTION	:
;*	INPUT		:
;*	OUTPUT		: NONE
;*	USES		: 
;*	CALLS		: NONE
;*	INFO		:
;*	TESTED		: 2 FEB 2007
;************************************************************************

;	 ORG	00066h		; HERE IS THE NMI ROUTINE
;	RETI

	 ORG	001FFh
FLAG	 DB	0FFh

 END
